//
//  DetailViewController.m
//  Presidents
//
//  Created by Robert Górczyński on 11-07-11.
//

#import "DetailViewController.h"
#import "RootViewController.h"
#import "LanguageListController.h"


@interface DetailViewController ()
@property (nonatomic, retain) UIPopoverController *popoverController;
- (void)configureView;
@end



@implementation DetailViewController

@synthesize toolbar, popoverController, detailItem, detailDescriptionLabel;
@synthesize webView;
@synthesize languageButton, languagePopoverController, languageString;

static NSString * modifyUrlForLanguage(NSString *url, NSString *lang) { 
    if (!lang) { 
        return url; 
    } 
	
	// W tym miejscu polegamy na określonym formacie adresu URL Wikipedii.
	// Trzeba zachować dużą ostrożność!
    NSRange languageCodeRange = NSMakeRange(7, 2); 
    if ([[url substringWithRange:languageCodeRange] isEqualToString:lang]) { 
        return url; 
    } else { 
        NSString *newUrl = [url stringByReplacingCharactersInRange:languageCodeRange 
														withString:lang]; 
        return newUrl; 
    } 
}

#pragma mark -
#pragma mark Zarządzanie widokiem szczegółowym

/*
 Po przygotowaniu elementu, następuje uaktualnienie widoku i usunięcie kontrolera popover, o ile to okno było wyświetlane.
 */
- (void)setDetailItem:(id)newDetailItem {
    if (detailItem != newDetailItem) {
        [detailItem release];
        detailItem = [newDetailItem retain];
        detailItem = [modifyUrlForLanguage(newDetailItem, languageString) retain];
		
        // Uaktualnienie widoku.
        [self configureView];
    }

    if (self.popoverController != nil) {
        [self.popoverController dismissPopoverAnimated:YES];
    }
	if (languagePopoverController != nil) { 
        [languagePopoverController dismissPopoverAnimated:YES]; 
    }	
}


- (void)configureView {
    // Uaktualnienie interfejsu użytkownika dla widoku szczegółowego.
    NSURL *url = [NSURL URLWithString:detailItem]; 
    NSURLRequest *request = [NSURLRequest requestWithURL:url]; 
    [self.webView loadRequest:request]; 	
    detailDescriptionLabel.text = [detailItem description];   
}


#pragma mark -
#pragma mark Obsługa widoku podzielonego

- (void)splitViewController: (UISplitViewController*)svc willHideViewController:(UIViewController *)aViewController withBarButtonItem:(UIBarButtonItem*)barButtonItem forPopoverController: (UIPopoverController*)pc {
    
    barButtonItem.title = @"Prezydenci";
    NSMutableArray *items = [[toolbar items] mutableCopy];
    [items insertObject:barButtonItem atIndex:0];
    [toolbar setItems:items animated:YES];
    [items release];
    self.popoverController = pc;
}


// Metoda jest wywoływana podczas ponownego wyświetlania widoku podzielonego i unieważnie przycisk oraz kontroler popover.
- (void)splitViewController: (UISplitViewController*)svc willShowViewController:(UIViewController *)aViewController invalidatingBarButtonItem:(UIBarButtonItem *)barButtonItem {
    
    NSMutableArray *items = [[toolbar items] mutableCopy];
    [items removeObjectAtIndex:0];
    [toolbar setItems:items animated:YES];
    [items release];
    self.popoverController = nil;
}


#pragma mark -
#pragma mark Obsługa rotacji

// Zagwarantowanie, że kontroler widoku obsługuje rotację, a tym samym widok podzielony może być wyświetlany zarówno w układzie pionowym jak i poziomym.
- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation {
    return YES;
}


#pragma mark -
#pragma mark Cykl życiowy widoku

- (void)viewDidUnload {
    // Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
    self.popoverController = nil;
	self.webView = nil;
	self.languageButton = nil; 
	self.languagePopoverController = nil;
}


#pragma mark -
#pragma mark Zarządzanie pamięcią

- (void)dealloc {
    [popoverController release];
    [toolbar release];
    
    [detailItem release];
    [detailDescriptionLabel release];
	[webView release];
	[languageButton release]; 
	[languagePopoverController release];
    [super dealloc];
}

- (void)setLanguageString:(NSString *)newString { 
    if (![newString isEqualToString:languageString]) { 
        [languageString release]; 
        languageString = [newString copy]; 
        self.detailItem = modifyUrlForLanguage(detailItem, languageString); 
    } 
}

- (IBAction)touchLanguageButton { 
    LanguageListController *languageListController = [[LanguageListController alloc] 
													  init]; 
    languageListController.detailViewController = self; 
    UIPopoverController *poc = [[UIPopoverController alloc] 
								initWithContentViewController:languageListController]; 
    [poc presentPopoverFromBarButtonItem:languageButton  
                permittedArrowDirections:UIPopoverArrowDirectionAny  
                                animated:YES]; 
    self.languagePopoverController = poc; 
    [poc release]; 
    [languageListController release]; 
}

@end
